open Lib.Options

let blank n =
  String.make n ' '

let sp = Printf.sprintf

let concat sep a = String.concat sep (List.filter ((<>) "") (Array.to_list a))

module Types = struct
  let sprint_option { name; value = { known_values } } =
    sp "  %s : %s;" name (type_of_known_values known_values)

  let enumerate_subcategory { name } =
    sp "  %s : %s;" name name

  let rec sprint_category { name; value = { sub_categories; options } } =
    let subs_t = concat "\n" (Array.map sprint_category sub_categories) in
    let subs = concat "\n" (Array.map enumerate_subcategory sub_categories) in
    let options = concat "\n" (Array.map sprint_option options) in
    sp "%stype %s = {\n%s\n}\n\n" subs_t name (concat "\n" [| subs; options |])
end

module Code = struct
  let sprint_option ~ind { name; value = { known_values } } =
    let value = default_of_known_values ~copy:true known_values in
    sp "%s%s = %s;" (blank (ind+2)) name value

  let rec sprint_category ~ind { name; value = { sub_categories; options } } =
    let ind = ind + 2 in
    let blank = blank ind in
    let subs = concat "\n" (Array.map (sprint_category ~ind) sub_categories) in
    let options = concat "\n" (Array.map (sprint_option ~ind) options) in
    sp "%s%s = {\n%s\n%s};" blank name (concat "\n" [| subs; options |]) blank

  let sprint_default category =
    let cs = Array.map (sprint_category ~ind:2) category.value.sub_categories in
    sp "let default () =\n  {\n%s\n  }\n" (concat "\n" cs)
end

let write ~s ~fd =
  assert (String.length s = Unix.write fd s 0 (String.length s))

let () =
  Dynlink.(try loadfile Sys.argv.(1) with Error e ->
    prerr_endline (error_message e));
  let ml = Unix.(openfile Sys.argv.(2) [ O_WRONLY; O_CREAT; O_TRUNC ] 0o644) in
  let mli = Unix.(openfile Sys.argv.(3) [ O_WRONLY; O_CREAT; O_TRUNC ] 0o644) in
  let types = Types.sprint_category !shared_category in
  let code = Code.sprint_default !shared_category in
  write ~s:types ~fd:ml;
  write ~s:code ~fd:ml;
  write ~s:types ~fd:mli;
  write ~s:(sp "val default : unit -> %s\n" !shared_category.name) ~fd:mli

