let make_gtkrc_string g_type shortcuts =
  let sp = Printf.sprintf in
  let b = Buffer.create 4000 in
  Buffer.add_string b "binding \"Shortcuts\" {";
  StdLabels.List.iter shortcuts ~f:(fun (signal, shortcut) ->
    Buffer.add_string b (sp "bind \"%s\" { \"%s\" () }" shortcut
    signal.GtkSignal.name));
  Buffer.add_string b "}";
  let classname = Gobject.Type.name g_type in
  Buffer.add_string b (sp "class \"%s\" binding \"Shortcuts\"" classname);
  Buffer.contents b

let create_shortcuts shortcuts obj =
  let g_type = Gobject.get_type obj in
  let f (signal, _shortcut) =
    GtkSignal.signal_new signal.GtkSignal.name g_type [ `ACTION; `RUN_FIRST ];
  in
  GtkMain.Rc.parse_string (make_gtkrc_string g_type shortcuts);
  List.iter f shortcuts

