class label ?packing ?(title="(no title)") () =
  let label = GPack.hbox ?packing () in
  let icon = GMisc.image ~packing:label#add ~height:16 ~stock:`NO () in
  let text = GMisc.label ~packing:label#add ~height:16 ~text:title () in
  let close =
    let button = GButton.button ~packing:label#add ~relief:`NONE () in
    (* NOTE: a height of 8 for the close button would be nice but that makes it
     * ugly. *)
    let image = GMisc.image ~stock:`CLOSE ~width:12 ~height:12 () in
    button#set_image image#coerce;
    button
  in
  (* XXX: always send a signal and let the creator of the widget destroy it! *)
  object(self)
    method label = label
    method icon = icon
    method text = text
    method close = close
    method coerce = label#coerce
  end

