let print_time =
  let time_ref = ref (Unix.gettimeofday ()) in
  let cpu_ref = ref (Sys.time ()) in
  fun text ->
    let time = Unix.gettimeofday () in
    let cpu = Sys.time () in
    let time_delta = time -. !time_ref in
    let cpu_delta = cpu -. !cpu_ref in
    time_ref := time;
    cpu_ref := cpu;
    Printf.eprintf "%s:\n" text;
    Printf.eprintf "  time+=%f; CPU+=%f\n%!" time_delta cpu_delta
