open Lib.Options

let list_find_index v l =
  let rec list_find_index_rc i v = function
    | t :: q when t = v -> i
    | t :: q -> list_find_index_rc (i+1) v q
    | [] -> raise Not_found
  in
  list_find_index_rc 0 v l

let setting_of_known_values ~packing ~options ~send ~path option_descr =
  let known_values = option_descr.value.known_values in
  let option = Lib.Options.option_of_path ~options path in
  let def_i = Lib.Options.value_index ~option ~option_descr in
  let combo_box_text () =
    let values = values_string_of_known_values known_values in
    let l = Array.to_list values in
    let box = fst (GEdit.combo_box_text ~packing ~active:def_i ~strings:l ()) in
    let callback () =
      let new_value = ith_option_descr ~i:box#active ~known_values in
      send (Lib.Options.update options new_value path)
    in
    ignore (box#connect#changed ~callback);
    box
  in
  match known_values with
  | Bool def ->
      (GButton.check_button ~packing ~active:(def_i <> 0) ())#as_widget
  | String _
  | Enum _
  | Int _
  | Float _ -> (combo_box_text ())#as_widget

let setting_of_option ~for_setting_ui ~(table : GPack.table) ~path option_descr =
  let size_groups, send, options = for_setting_ui in
  let i = List.hd path in
  let path = List.rev path in
  let size_group_label, size_group_opt = size_groups in
  let packing ~left widget = table#attach ~left ~top:i widget in
  let label = GMisc.label ~text:option_descr.name ~packing:(packing ~left:1) () in
  let opt = setting_of_known_values ~packing:(packing ~left:2) ~options ~send ~path option_descr in
  GtkPack.SizeGroup.add_widget size_group_label label#as_widget;
  GtkPack.SizeGroup.add_widget size_group_opt opt

let build_options ~packing ~for_setting_ui ~path category_descr =
  let options_descr = category_descr.value.options in
  let n_options = Array.length options_descr in
  if n_options > 0 then
    let table = GPack.table ~packing ~columns:2 ~rows:n_options () in
    for i = 0 to n_options - 1 do
      let path = (i + Array.length category_descr.value.sub_categories) :: path in
      setting_of_option ~for_setting_ui ~table ~path options_descr.(i) 
    done

let rec build_category ?(is_first=false) ~packing ~for_setting_ui ~path category_descr =
  let box_packing =
    if is_first then
      packing
    else
      let frame = GBin.frame ~packing ~label:category_descr.name () in
      frame#add
  in
  let box = GPack.vbox ~packing:box_packing ~spacing:2 () in
  let sub_categories = category_descr.value.sub_categories in
  for i = 0 to Array.length sub_categories - 1 do
    let path = i :: path in
    build_category ~packing:box#pack ~for_setting_ui ~path sub_categories.(i)
  done;
  build_options ~packing:box#pack ~for_setting_ui ~path category_descr

let build_category_tab ~packing ~for_setting_ui ~path category_descr =
  let notebook = GPack.notebook ~packing ~tab_pos:`LEFT () in
  build_options ~packing ~for_setting_ui ~path category_descr;
  let sub_categories_descr = category_descr.value.sub_categories in
  for i = 0 to Array.length sub_categories_descr - 1 do
    let cat_descr = sub_categories_descr.(i) in
    let tab_label = GMisc.label ~text:cat_descr.name () in
    let packing widget =
      ignore (notebook#append_page ~tab_label:tab_label#coerce widget)
    in
    let path = i :: path in
    build_category ~is_first:true ~packing ~for_setting_ui ~path cat_descr
  done

let build ~options_descr ~send ~options = 
  let title = String.concat " " [ options_descr.name; "Options" ] in
  let w = GWindow.dialog ~title () in
  w#add_button_stock `OK `OK;
  let size_group_label = GtkPack.SizeGroup.create [] in
  let size_group_opt = GtkPack.SizeGroup.create [] in
  let size_groups = size_group_label, size_group_opt in
  let for_setting_ui = size_groups, send, options in
  build_category_tab ~packing:w#vbox#pack ~for_setting_ui ~path:[] options_descr;
  match w#run () with
  | `DELETE_EVENT
  | `OK -> w#destroy ()

