open Lib.Options

let default_uri_scheme = {
  name = "default_uri_scheme";
  short_description = "Protocol to default to when no scheme is given in the address bar";
  long_description = "When no scheme (http://, ftp://, ...) is given, use this as the default";
  level = 9;
  value = {
    immediate = true;
    known_values = String ("http", [| "http"; "ftp"; "file" |]);
    can_be_user_specified = false;
  }
}

let new_page_default_uri = {
  name = "new_page_default_uri";
  short_description = "URI to load by default when creating a new page.";
  long_description = "URI to load by default when creating a new page.";
  level = 9;
  value = {
    immediate = true;
    known_values = String ("about:blank", [|
      "about:blank";
    |]);
    can_be_user_specified = true;
  }
}

let page = {
  name = "page";
  short_description = "Page options";
  long_description = "Page options";
  level = 0;
  value = {
    sub_categories = [| |];
    options = [| default_uri_scheme; new_page_default_uri |];
  }
}

let tabs_position = {
  name = "tabs_position";
  short_description = "Where to place tabs on the screen.";
  long_description = "Where to place tabs on the screen.";
  level = 9;
  value = {
    immediate = true;
    known_values = Enum ("`TOP", [|
      "Top", Obj.repr `TOP;
      "Left", Obj.repr `LEFT;
      "Bottom", Obj.repr `BOTTOM;
      "Right", Obj.repr `RIGHT
    |], "Gtk.Tags.position");
    can_be_user_specified = false;
  }
}

let new_tab_placement = {
  name = "new_tab_placement";
  short_description = "Where to place new tabs on opening.";
  long_description = "Where to place new tabs on opening.";
  level = 9;
  value = {
    immediate = true;
    known_values = Enum ("`End", [|
      "After", Obj.repr `After;
      "Before", Obj.repr `Before;
      "Beginning", Obj.repr `Beginning;
      "End", Obj.repr `End
    |], "Zipper.where_add");
    can_be_user_specified = false;
  }
}

let post_close_activate = {
  name = "post_close_activate";
  short_description = "Which tab to activate after the current one has been closed.";
  long_description = "Which tab to activate after the current one has been closed.";
  level = 9;
  value = {
    immediate = true;
    known_values = Enum ("`After", [|
      "After", Obj.repr `After;
      "Before", Obj.repr `Before;
    |], "Zipper.where_remove");
    can_be_user_specified = false;
  }
}

let navigation = {
  name = "navigation";
  short_description = "Navigation options";
  long_description = "Navigation options";
  level = 0;
  value = {
    sub_categories = [| page |];
    options = [| tabs_position; new_tab_placement; post_close_activate |];
  }
}

let browser = {
  name = "browser";
  short_description = "Browser options";
  long_description = "Browser options";
  level = 0;
  value = {
    sub_categories = [| navigation |];
    options = [| |];
  }
}

let () =
  if Filename.basename Sys.argv.(0) = "options.native" then
    Lib.Options.shared_category := browser

