type page = {
  default_uri_scheme : string;
  new_page_default_uri : string;
}

type navigation = {
  page : page;
  tabs_position : Gtk.Tags.position;
  new_tab_placement : Zipper.where_add;
  post_close_activate : Zipper.where_remove;
}

type browser = {
  navigation : navigation;
}

let default () =
  {
    navigation = {
      page = {
        default_uri_scheme = String.copy "http";
        new_page_default_uri = String.copy "about:blank";
      };
      tabs_position = `TOP;
      new_tab_placement = `End;
      post_close_activate = `After;
    };
  }
