module Page0 :
  sig
    type options = Options.page
    type t = {
      uri : string;
      title : string;
      history : string list;
      options : options;
      id : LablgtkReact.id;
      parent_id : LablgtkReact.id option;
    }
    type init = LablgtkReact.id * LablgtkReact.id option * options
    type action_common = [
      | `Uri of string
      | `Title of string
      | `SetOptions of options
      | `Close
    ]
    type action_functional = [
      action_common
      | `Request of [ `Close | `Popup ]
    ]
    type action_ui = [
      action_common
      | `Request of [ `Add | `Close | `Popup ]
    ]
    val create : init -> t * action_ui
    val on_action_func : t -> action_functional -> t * action_ui
  end

module Navigation0 :
  sig
    type t = { z : Page0.t Zipper.t; options : Options.navigation; }
    type init = Options.navigation
    type action_common = [
      | `Nth of int
      | `MoveTo of int
      | `SetOptions of Options.navigation
    ]
    type action_functional = [
      action_common
      | `CloseCurrent
      | `Set of (Page0.t * Page0.action_ui)
    ]
    type action_ui = [
      action_common
      | `Close of (LablgtkReact.id * int option)
      | `Popup of LablgtkReact.id
      | `Add of LablgtkReact.id
      | `None
    ]
    val create : Options.navigation -> t * action_ui
    val on_action_func : t -> action_functional -> t * action_ui
  end

module Browser0 :
  sig
    type options = Options.browser
    type t = { options : options; navigation : Navigation0.t; }
    type init = options
    type action_common = [ `SetOptions of options ]
    type action_functional = [
      action_common
      | `Set of (Navigation0.t * Navigation0.action_ui)
    ]
    type action_ui = [ action_common | `None ]
    val create : options -> t * action_ui
    val on_action_func : t -> action_functional -> t * action_ui
  end
