open BrowserModel.Types

let load_options () =
  try
    let ic = open_in_bin "caravel.conf" in
    let options = Marshal.from_channel ic in
    close_in ic;
    options
  with _ ->
    BrowserModel.Options.default ()

let () =
  Lib.Misc.print_time "Static initializations done";
  let _locale = GtkMain.Main.init () in
  Lib.Misc.print_time "GTK initialization done";
  let options = load_options () in
  Lib.Misc.print_time "Options loading done";
  let browser = new BrowserUI.MainWindow.browser options in
  Lib.Misc.print_time "Browser creation done";
  browser#window#show ();
  Lib.Misc.print_time "Browser window displayed";
  (if Array.length Sys.argv > 1 then
    browser#new_page ~uri:Sys.argv.(1) ()
  else
    browser#new_page ());
  GtkThread.main ()

