module Misc : sig
val print_time : string -> unit
end
module Options : sig
type known_values =
    String of (string * string array)
  | Enum of (string * (string * Obj.t) array * string)
  | Int of (int * int array)
  | Float of (float * float array)
  | Bool of bool
val type_of_known_values : known_values -> string
val default_of_known_values : ?copy:bool -> known_values -> string
val values_string_of_known_values : known_values -> string array
type 'a wrap = {
  name : string;
  short_description : string;
  long_description : string;
  level : int;
  value : 'a;
}
type opt = {
  known_values : known_values;
  can_be_user_specified : bool;
  immediate : bool;
}
type category = {
  sub_categories : category wrap array;
  options : opt wrap array;
}
val option_of_path : options:'a -> int list -> 'b
val value_index : option:bool -> option_descr:opt wrap -> int
val ith_option_descr : i:int -> known_values:known_values -> Obj.t
val update : 'a -> 'b -> int list -> 'a
val shared_category : category wrap ref
end
