module Options : sig
type page = {
  default_uri_scheme : string;
  new_page_default_uri : string;
}
type navigation = {
  page : page;
  tabs_position : Gtk.Tags.position;
  new_tab_placement : Zipper.where_add;
  post_close_activate : Zipper.where_remove;
}

type browser = {
  navigation : navigation;
}

val default : unit -> browser
end
module OptionsDescr : sig
val browser : Lib.Options.category Lib.Options.wrap
end
module Browser : sig
module Page0 :
  sig
    type options = Options.page
    type t = {
      uri : string;
      title : string;
      history : string list;
      options : options;
      id : LablgtkReact.id;
      parent_id : LablgtkReact.id option;
    }
    type init = LablgtkReact.id * LablgtkReact.id option * options
    type action_common = [
      | `Uri of string
      | `Title of string
      | `SetOptions of options
      | `Close
    ]
    type action_functional = [
      action_common
      | `Request of [ `Close | `Popup ]
    ]
    type action_ui = [
      action_common
      | `Request of [ `Add | `Close | `Popup ]
    ]
  end
module Navigation0 :
  sig
    type t = { z : Page0.t Zipper.t; options : Options.navigation; }
    type init = Options.navigation
    type action_common = [
      | `Nth of int
      | `MoveTo of int
      | `SetOptions of Options.navigation
    ]
    type action_functional = [
      action_common
      | `CloseCurrent
      | `Set of (Page0.t * Page0.action_ui)
    ]
    type action_ui = [
      action_common
      | `Close of (LablgtkReact.id * int option)
      | `Popup of LablgtkReact.id
      | `Add of LablgtkReact.id
      | `None
    ]
  end
module Browser0 :
  sig
    type options = Options.browser
    type t = { options : options; navigation : Navigation0.t; }
    type init = options
    type action_common = [ `SetOptions of options ]
    type action_functional = [
      action_common
      | `Set of (Navigation0.t * Navigation0.action_ui)
    ]
    type action_ui = [ action_common | `None ]
  end
end
module Types : sig
  module Page : sig
    class core :
      ?state_callbacks:((Browser.Page0.t * Browser.Page0.action_ui) -> unit) list ->
      ?msg_callbacks:(Browser.Page0.action_ui -> unit) list ->
      Browser.Page0.init ->
      object
        method msg_callbacks : Browser.Page0.action_ui LablgtkReact.callbacks
        method send : Browser.Page0.action_functional -> unit
        method state_callbacks : (Browser.Page0.t * Browser.Page0.action_ui) LablgtkReact.callbacks
      end
    end
  module Navigation : sig
    class core :
      ?state_callbacks:((Browser.Navigation0.t * Browser.Navigation0.action_ui) -> unit) list ->
      ?msg_callbacks:(Browser.Navigation0.action_ui -> unit) list ->
      Browser.Navigation0.init ->
      object
        method msg_callbacks : Browser.Navigation0.action_ui LablgtkReact.callbacks
        method send : Browser.Navigation0.action_functional -> unit
        method state_callbacks : (Browser.Navigation0.t * Browser.Navigation0.action_ui) LablgtkReact.callbacks
      end
  end
  module Browser :
    sig
      class core :
        ?state_callbacks:((Browser.Browser0.t * Browser.Browser0.action_ui) -> unit) list ->
        ?msg_callbacks:(Browser.Browser0.action_ui -> unit) list ->
        Browser.Browser0.init ->
        object
          method msg_callbacks : Browser.Browser0.action_ui LablgtkReact.callbacks
          method send : Browser.Browser0.action_functional -> unit
          method state_callbacks : (Browser.Browser0.t * Browser.Browser0.action_ui) LablgtkReact.callbacks
        end
    end
end
